"""SecureLink Pi Gateway Agent - Configuration and constants."""

import os
from pathlib import Path

# Directories
SECURELINK_DIR = Path(os.environ.get('SECURELINK_DIR', '/etc/securelink'))
CLAIM_DIR = SECURELINK_DIR / 'claim'
DEVICE_DIR = SECURELINK_DIR / 'device'
STATE_DIR = Path('/var/lib/securelink')
LOG_DIR = Path('/var/log/securelink')

# Claim certificate paths (embedded in image)
CLAIM_CERT = CLAIM_DIR / 'claim-cert.pem'
CLAIM_KEY = CLAIM_DIR / 'claim-key.pem'
AWS_ROOT_CA = CLAIM_DIR / 'aws-root-ca.pem'

# Device certificate paths (created during provisioning)
DEVICE_CERT = DEVICE_DIR / 'device-cert.pem'
DEVICE_KEY = DEVICE_DIR / 'device-key.pem'
DEVICE_CONFIG = DEVICE_DIR / 'config.json'

# VPN certificate paths (received from activation API)
VPN_CA_CERT = DEVICE_DIR / 'ca-cert.pem'
VPN_DEVICE_CERT = DEVICE_DIR / 'vpn-device-cert.pem'
VPN_DEVICE_KEY = DEVICE_DIR / 'vpn-device-key.pem'

# strongSwan config paths
IPSEC_CONF = Path('/etc/ipsec.d/securelink-vpn.conf')
IPSEC_SECRETS = Path('/etc/ipsec.d/securelink-vpn.secrets')

# Serial number file
SERIAL_FILE = SECURELINK_DIR / 'serial'

# State file
STATE_FILE = STATE_DIR / 'agent-state.json'

# AWS IoT
IOT_ENDPOINT = os.environ.get('IOT_ENDPOINT', '')
IOT_PROVISIONING_TEMPLATE = 'SecureLinkGateway'

# SecureLink API
API_URL = os.environ.get('SECURELINK_API_URL',
                         'https://178n7v4mri.execute-api.us-east-1.amazonaws.com/dev')

# Status reporting
STATUS_INTERVAL = 60  # seconds
